/*------------------------------------------------------------------------------*
 * File Name:ANOVATwoWay.h														*
 * Creation:  																	*
 * Purpose: OriginC header file for declaration of  Tow Way ANOVA operation 	*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	ML 10/25/2005 MUST_CLEAN_UP_CACHED_STUFF									*
 *  Jim 3/15/06 ADD_TABLE_FOOTNOTE												*
 *	Max 11/17/06 MOVE_TO_ANOVATWOWAYRM.H										*	
 *	Echo 2/7/07 ADD_ERROR_REPORT												*
 *	Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE										*
 *	Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING	*
 *	Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL 						*
 *------------------------------------------------------------------------------*/
#include <o8dlg.h>
#ifndef	_ANOVATWOWAY_H
#define	_ANOVATWOWAY_H
///Iris 12/22/04 CLEANUP_AND_USE_BASE_CLASS_FIX
//class OC_REGISTERED ANOVATwoWay : public WksReportOperation
class OC_REGISTERED ANOVATwoWay : public ANOVAReportOperation
{
///Echo 2/7/07 ADD_ERROR_REPORT
public:
	PEVENT_GETN GetNewEventFunction();
///end ADD_ERROR_REPORT

	///Arvin 06/29/07 v8.652 XOP_NEED_SUPPORT_NLFIT
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	/*
	int OnInitOperationTreeFromOCLT(TreeNode &trOp, TreeNode& trOCLT, bool bInitTree = true)
	{
		int nRet;
		TreeNode trOutGUI = trOCLT.GetNode("GUI");
		TreeNode trInputData = trOutGUI.InputData;
		if(!trInputData)
			return OP_INVALID_INPUT_DATA_NODE;
		
		if(ANOVA_INDEXED_DATA == trInputData.Use)
		{
			nRet = okutil_anova_switch_to_indexed_data(&trInputData, true, false);			
		}
		else
		{
			 nRet = okutil_anova_switch_to_raw_data(&trInputData, true, false);
		}
		
		return nRet;
	}
	*/
	///end CLEAN_ANOVA_TOOLS_CODE
	///END XOP_NEED_SUPPORT_NLFIT

protected:
	//BOOL 				Construct(TreeNode& trOperation, int nOption); /// Iris 12/27/05 CONSTRUCT_RM_BASE_CLASS
	//virtual
	int					GetResultCurvesID();
	/// Iris 3/21/2008 v8.0829 QA80-10934 ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME, want GUI tree as input in DescStats::GetResultSheetName
	//string 			GetResultSheetName(); 
	string 			GetResultSheetName(TreeNode& trGUI);
	string 			GetResultBookName(TreeNode& trGUI);
	///end ADD_EDITBOX_TO_SPECIFICATION_BOOK_SHEET_NAME
	//virtual
	bool 				GetCustomGraphTypeName(string& strName, int nIndex);
	void 				UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExeMode);

	//virtual
	BOOL				CalcOneData(TreeNode &trOp, int index, int nTotalNumData, const vector<int> &vFactorSizes,
								const vector<string> &vstrFactors, vector &vData, vector &vDummy, matrix &mDummy, vector &vWeights, 
								DWORD dwPlotObjUID, int nRowColIndex, const vector<int>& vintRowsInSource = NULL);
								
	/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
	// virtual
	//int					GetDRTreeOption(TreeNode &trOperation); /// Iris 12/27/05 CONSTRUCT_RM_BASE_CLASS, move to base class
	/// end ANOVA_INPUT_DATA_TO_DATARANGE
	/// ML 10/25/2005 MUST_CLEAN_UP_CACHED_STUFF
	// virtual
	void				OnAfterCalculations(TreeNode& trOp);
	/// end MUST_CLEAN_UP_CACHED_STUFF
	
	/// Iris 12/27/05 CONSTRUCT_RM_BASE_CLASS
	virtual bool		IsOneWay()		{return false;}
	///End CONSTRUCT_RM_BASE_CLASS
	string 				GetClassName();
	///Cheney 2007-9-28 MODIFY_TITLE_AS_MAX_SAID
	//virtual
	string				GetDlgDescription(int nOption);
	///end MODIFY_TITLE_AS_MAX_SAID
	///Cheney 2007-10-25 ANOVA_TOOLS_HANDLE_AUTO_WRONG
	//virtual
	bool GetAnovaToolsOption(bool bRow, int& nOption);
	///end ANOVA_TOOLS_HANDLE_AUTO_WRONG
	//--- Jacky 07/22/10 ORG-102 USER_CAN_SET_SIGNIFICANCE_LEVEL 	
	double GetAlphaValue();
	//--- end USER_CAN_SET_SIGNIFICANCE_LEVEL
	
private:
	void				getDependentData(const vector& vData);
	bool				getFactors(const vector<string> &vstrFactors, int nDataSize);
	BOOL				addResultsToReportTree(TreeNode &trOp, int nDataGroups);
	void				addANOVAsTable(TreeNode &trOp, ANOVA2Table*	parANOVA2Table, int nSize, int nDataGroups);
	int 				addDescStatsTable(TreeNode &trOp, ANOVA2Table* parANOVA2Table);
	BOOL				addOverallANOVA(TreeNode &trOp, ANOVA2Table* parANOVA2Table, int nSize);
	BOOL				addOneMeanComparisonResult(TreeNode &trOp, const int nIntervalType, ANOVA2Table* parANOVA2Table, int nSize);
	BOOL				addMeanCompStatsTable(TreeNode &trOp, const int iTestType, const vector<int> &vFactor, 
							const vector<string>& vsFactors, string strTypeName, string strTypeLabel, int nID, 
							string strFactor, string strFactorName, int index, ANOVA2Table* parANOVA2Table, int nSize);
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	//bool 				addMeanComparisonFootnote(TreeNode &trOp); 	///Jim 3/15/06 v8.0374 ADD_TABLE_FOOTNOTE 
	///end CLEAN_ANOVA_TOOLS_CODE
	void 				addANOVATwoWayMeansComparison(TreeNode &trOp, ANOVA2Table*	parANOVA2Table, int nSize);
	void				addPowersResult(TreeNode &trOp, ANOVA2Table* parANOVA2Table, int nSize);
	void				updateOnePowerTable(TreeNode &trOp, int iFactorIndex, int iLevels, int iPower, const int iInteractions, int iSource, ANOVA2Table* parANOVA2Table, int nDataGroup);
	void 				addNodeToMeanWksTable(TreeNode& trTable, vector<string> vsNames, vector<string> vsLabels, int nBaseID);
	void 				addMeansWksTable(TreeNode& trOp, ANOVA2DescStats* pstDescStats, int DescStatsSize, bool bCreateGraph, string strTable, int nID, bool bIsSD = true);
	bool				isCreateGraph(TreeNode& trOp, int nGraphIndex);
	void 				addWksTableMeanFactorA(TreeNode& trOp, ANOVA2DescStats*	pstDescStatsA, int nSizeFactorA, bool bCreateGraph);
	void 				addWksTableMeanFactorB(TreeNode& trOp, ANOVA2DescStats*	pstDescStatsB, int nSizeFactorB, bool bCreateGraph);
	void 				addWksTableMeanFactorAB(TreeNode& trOp, ANOVA2DescStats* pstDescStatsAB, int nSizeFactorAB, bool bCreateGraph);
	///Arvin 10/17/07 CLEAN_ANOVA_TOOLS_CODE
	/*
	void 				addErrorRowToTable(TreeNode& trTable, string strError, int nID);
	void				addErrInfoDescSrtats(TreeNode& trTable, int nID, int nErr);
	void 				addErrInfoMeanComparison(TreeNode& trTable, int nID, int nErr);
	void 				addErrInfoANOVAPower(TreeNode& trTable, int nID, int nErr);
	*/
	///end CLEAN_ANOVA_TOOLS_CODE
	/// Hong 09/04/09 QA80-14258 HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	//virtual bool		InitFromSelection(TreeNode &trOperation);
	virtual int			InitFromSelection(TreeNode &trOperation);
	/// end HISTOGRAM_NEED_SPECIAL_HINT_FOR_DOING_NLFITTING
	void 				updateDescTableLabels(TreeNode& trRow);
	void				sortFactors();
	///Arvin 11/16/07 QA70-10669 IMPROVE_TABLES_ROW_LABELS_FOR_ANOVA_TOOLS
	int					getOverallANOVATableRowLabels(vector<string>& vstrLabels);
	///end IMPROVE_TABLES_ROW_LABELS_FOR_ANOVA_TOOLS
protected:
	vector<int>		m_vnFactorA;
	vector<int>		m_vnFactorB;
	//vector<string>	m_vsFactorA;
	//vector<string>	m_vsFactorB;
	
	//virtual
	// fisher 11/16/2007 ADD_MAP_ID_TO_CHM
	int GetHelpID()	{return IDD_XF_ANOVATwoWay;}
		
};
/// Max 11/17/06 MOVE_TO_ANOVATWOWAYRM.H
/*
class OC_REGISTERED ANOVATwoWayRM : public ANOVARMReportOperation
{
protected:
	virtual bool	IsRM()		{return true;}	
	virtual bool	IsOneWay()	{return false;}	
	virtual void 	UpdateReportingTables(TreeNode &trOperation, int nTotalNumData, int nExeMode);
	virtual void 	ConstructOutputTable(TreeNode& trOperation);
	bool	CalcOneData(TreeNode &trOp, int nSizeSubject, int nSizeFactor, int& nSizeFactor2 = NULL);
	int     ExtractIndexedData(TreeNode &trOp, DataRange& dr, matrix& mData, int& nSizeSubject, int& nSizeFactor, int& nSizeFactor2);
	int     ExtractRawData(TreeNode &trOp, DataRange& dr, matrix& mData, int& nSizeSubject, int& nSizeFactor, int& nSizeFactor2 = NULL);

private:
	bool    getData(TreeNode &trOp, matrix &matData, vector<int> &vData, vector<int> &vNonRVData);

	
private:
	vector<int>		m_vNonRVData;
	int				m_nRV; //the repeated format
	int				m_nGroupSize; 
};
*/
/// END MOVE_TO_ANOVATWOWAYRM.H

#endif //_ANOVATWOWAY_H